/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.impl2;

import filenet.sim.animationdp.IVWSIMQueueOpStats;
import filenet.sim.animationdp.IVWSIMQueueStats;
import filenet.sim.animationdp.impl2.QueueOpStats;
import filenet.sim.animationdp.impl2.StatObj;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;

public class QueueStats
extends StatObj
implements IVWSIMQueueStats {
    static final long serialVersionUID = 1L;
    private String name;
    private String id;
    private Hashtable qOpStats = new Hashtable(1);

    public String getName() {
        return this.name;
    }

    public int getActiveWorkItemCount() {
        return this.nActive;
    }

    public int getCompletedWorkItemCount() {
        return this.nCompleted;
    }

    public int getOverdueWorkItemCount() {
        return this.nOverdue;
    }

    public double getTotalCost() {
        return this.totalCost;
    }

    public double getAverageCost() {
        return this.avgCost;
    }

    public IVWSIMQueueOpStats[] getQueueOpStats() {
        return this.qOpStats.values().toArray(new IVWSIMQueueOpStats[0]);
    }

    protected String getId() {
        return this.id;
    }

    public void readFromStream(DataInput in) throws IOException {
        String marker = in.readUTF();
        this.nCompleted = in.readInt();
        this.nActive = in.readInt();
        this.nOverdue = in.readInt();
        this.totalCost = in.readDouble();
        this.avgCost = in.readDouble();
        this.name = in.readUTF();
        this.id = in.readUTF();
        int count = in.readInt();
        while (count-- > 0) {
            QueueOpStats qOp = new QueueOpStats();
            qOp.readFromStream(in);
            this.qOpStats.put(qOp.getSId(), qOp);
        }
    }

    protected void merge(QueueStats q) {
        this.nCompleted = q.nCompleted;
        this.nActive = q.nActive;
        this.nOverdue = q.nOverdue;
        this.totalCost = q.totalCost;
        this.avgCost = q.avgCost;
        for (QueueOpStats qOp : q.qOpStats.values()) {
            this.qOpStats.put(qOp.getSId(), qOp);
        }
    }

    public void toString(StringBuffer buf) {
        buf.append("\n<Queue name=\"").append(this.name).append("\" nActive=\"").append(this.nActive).append("\" nCompleted=\"").append(this.nCompleted).append("\" nOverdue=\"").append(this.nOverdue).append("\" avgCost=\"").append(this.avgCost).append("\" totalCost=\"").append(this.totalCost).append("\">\n<QueueOps>");
        Iterator iter = this.qOpStats.values().iterator();
        while (iter.hasNext()) {
            ((QueueOpStats)iter.next()).toString(buf);
        }
        buf.append("\n</QueueOps></Queue>");
    }

    protected int getToStringSize() {
        int size = 128;
        Iterator iter = this.qOpStats.values().iterator();
        while (iter.hasNext()) {
            size += ((QueueOpStats)iter.next()).getToStringSize();
        }
        return size;
    }

    public void writeToStream(DataOutput out) throws IOException {
        out.writeUTF("QSTATS.1.0");
        out.writeInt(this.nCompleted);
        out.writeInt(this.nActive);
        out.writeInt(this.nOverdue);
        out.writeDouble(this.totalCost);
        out.writeDouble(this.avgCost);
        out.writeUTF(this.name);
        out.writeUTF(this.id);
        out.writeInt(this.qOpStats.size());
        for (QueueOpStats qOp : this.qOpStats.values()) {
            qOp.writeToStream(out);
        }
    }
}

